#include	<stdio.h>
#include        <locale.h> /* include the declaraiton of setlocale(),
                          localeconv() etc. */
#include        <wchar.h> /* include the declaration of wcswidth(),
                             wcwidth, etc. */

main(argc, argv, envp)
int argc;
char *argv[];
char **envp;
{
        FILE *ifp;    /* the input file handle. */
        wint_t wc;    /* wide character to hold the character read in. */
        int	display_width; /* keeping track of how many display     
                                  columns has been taken up so far. */
        
	if ( argc < 2 ) {
	  printf("Usage: %s inputfile-name.\n", argv[0]);
          exit (-1);
	}
     
        setlocale(LC_ALL,"");

        ifp = fopen(argv[1], "r"); /* open the inputf file. */

        display_width = 0;            /* initialize the total display
					 width to 0 */

        /* Read in one wide character at a time, and loop until
           end-of-file is reached. */
        while ( (wc = fgetwc(ifp)) != WEOF ) {

                             /* Increment total display width which will be
                                the display width including the character
                                just read in. */ 
                display_width += wcwidth(wc);

                             /* If we will not exceed 40 columns, then
                                print the character to stdout. */
                if ( display_width < 40 || display_width == 40 ) 
                        putwchar(wc);

                             /* Otherwise, push the wide character back
                                to stdin, print out new line, and reset
                                total display width to start working
                                on next line.    */
                else {
                  	ungetwc( (wint_t)wc, ifp);
                        printf("\n");
                        display_width = 0;
	             }    

        } /* while ( (wc = fgetwc(ifp)) != WEOF ) */
} 
